/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.ErrorDataBlock;
import com.quantumdata.busmon.parser.HDMIPacketTrace;
import com.quantumdata.busmon.parser.Packet;
import com.quantumdata.busmon.parser.PacketTrace;
import com.quantumdata.busmon.parser.TypeConverter;
import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import com.quantumdata.std.SystemConsole;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Vector;
import javax.swing.JOptionPane;

public final class Parser
extends Thread {
    private InetSocketAddress logAddress;
    private Socket logSocket;
    private InputStream logIn;
    public static PacketTrace packets;
    public static SocketConnection connection;
    public static RemoteInstrument instrument;
    public static IQDConsole console;
    public static String address;
    private boolean capturing;
    private int number;
    private int capturePortDDC;
    private int capturePortCEC;
    private int capturePortDisplayPort;

    public Parser() {
        connection = new SocketConnection("");
        console = new SystemConsole();
        instrument = new RemoteInstrument(connection, console);
        this.setDaemon(true);
        this.capturing = false;
    }

    public void run() {
        while (true) {
            try {
                Parser.sleep(0L, 5000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.capturing) continue;
            if (!instrument.isConnected()) {
                this.setCapturing(false);
                continue;
            }
            if (this.logSocket == null) {
                this.setCapturing(false);
                continue;
            }
            if (this.logSocket.isClosed()) {
                this.setCapturing(false);
                continue;
            }
            if (this.logIn == null) {
                this.setCapturing(false);
                continue;
            }
            try {
                DataBlock dataBlock;
                Packet packet;
                int n = this.logIn.read();
                if (n != 1) continue;
                Vector<Integer> vector = new Vector<Integer>();
                vector.add(n);
                vector.add(this.logIn.read());
                vector.add(this.logIn.read());
                vector.add(this.logIn.read());
                vector.add(this.logIn.read());
                vector.add(this.logIn.read());
                vector.add(this.logIn.read());
                long l = TypeConverter.composeLong(vector, 3);
                for (long i = 0L; i < l; ++i) {
                    vector.add(this.logIn.read());
                }
                if (packets instanceof HDMIPacketTrace) {
                    if (Packet.getPacketSource(vector) != 1) {
                        packet = new Packet(vector, this.number);
                        if (packet.isI2C()) {
                            dataBlock = packet.getDataBlock();
                            if (dataBlock.getSourceID() == this.capturePortDDC) {
                                packets.add(packet);
                            }
                        } else {
                            packets.add(packet);
                        }
                    } else if (Packet.getCECDataBlockSourceID(vector) == this.capturePortCEC) {
                        packet = new Packet(vector, this.number);
                        packets.add(packet);
                    }
                } else {
                    packet = new Packet(vector, this.number);
                    dataBlock = packet.getDataBlock();
                    if (dataBlock.getSourceID() == this.capturePortDisplayPort || dataBlock instanceof ErrorDataBlock) {
                        packets.add(packet);
                    }
                }
                ++this.number;
                continue;
            }
            catch (IOException iOException) {
                this.setCapturing(false);
                continue;
            }
            break;
        }
    }

    public void setCapturing(boolean bl) {
        if (bl == this.capturing) {
            return;
        }
        this.number = 1;
        if (!bl) {
            InstrumentResponse instrumentResponse;
            String string;
            this.capturing = false;
            if (this.capturePortDDC > 0) {
                string = String.format("DDC%1d:DCMG 0", this.capturePortDDC);
                instrumentResponse = instrument.sendCmd(string);
            }
            if (this.capturePortCEC > 0) {
                string = String.format("CEC%1d:BUSM:OFF", this.capturePortCEC);
                instrumentResponse = instrument.sendCmd(string);
            }
            if (this.capturePortDisplayPort > 0) {
                string = String.format("ADM%1d:ADMG 0", this.capturePortDisplayPort);
                instrumentResponse = instrument.sendCmd(string);
            }
            try {
                this.logSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.capturePortDDC > 0) {
                string = String.format("DDC%1d:LOGG 0", this.capturePortDDC);
                instrumentResponse = instrument.sendCmd(string);
            }
            if (this.capturePortCEC > 0) {
                string = String.format("CEC%1d:LOGG 0", this.capturePortCEC);
                instrumentResponse = instrument.sendCmd(string);
            }
        } else {
            InstrumentResponse instrumentResponse;
            String string;
            if (!instrument.isConnected()) {
                return;
            }
            this.logAddress = new InetSocketAddress(address, 40000);
            this.logSocket = new Socket();
            try {
                this.logSocket.connect(this.logAddress);
                this.logIn = this.logSocket.getInputStream();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(Sniffer.window, "An error occurred while attempting to establish a network connection to the analyzer's log server port:\n" + exception.getMessage());
                return;
            }
            if (MainAppFrame.numDDCPorts > 0 && this.capturePortDDC > 0) {
                string = "DDCX:LOGM 5";
                instrumentResponse = instrument.sendCmd(string);
                if (instrumentResponse.isError()) {
                    JOptionPane.showMessageDialog(Sniffer.window, "An error occurred while attempting to connect to the I2C log server.  The command was:\n" + string + "\nThe response was:\n" + instrumentResponse.getResponse());
                    return;
                }
                string = String.format("DDC%1d:LOGG 1", this.capturePortDDC);
                instrumentResponse = instrument.sendCmd(string);
                if (instrumentResponse.isError()) {
                    JOptionPane.showMessageDialog(Sniffer.window, "An error occurred while attempting to connect to the I2C log server.  The command was:\n" + string + "\nThe response was:\n" + instrumentResponse.getResponse());
                    return;
                }
                string = String.format("DDC%1d:DCMG 1", this.capturePortDDC);
                instrumentResponse = instrument.sendCmd(string);
                this.capturing = true;
            }
            if (MainAppFrame.numDisplayPorts > 0 && this.capturePortDisplayPort > 0) {
                string = String.format("ADM%1d:ADMG 1", this.capturePortDisplayPort);
                instrumentResponse = instrument.sendCmd(string);
                this.capturing = true;
            }
            if (MainAppFrame.numCECPorts > 0 && this.capturePortCEC > 0) {
                string = "CECX:LOGM 4001";
                instrumentResponse = instrument.sendCmd(string);
                if (instrumentResponse.isError()) {
                    JOptionPane.showMessageDialog(Sniffer.window, "An error occurred while attempting to connect to the CEC log server.  The command was:\n" + string + "\nThe response was:\n" + instrumentResponse.getResponse());
                    return;
                }
                string = String.format("CEC%1d:LA?", this.capturePortCEC);
                instrumentResponse = instrument.sendCmd(string);
                if (Integer.parseInt(instrumentResponse.getResponse()) >= 0) {
                    string = String.format("CEC%1d:LOGG 1", this.capturePortCEC);
                    instrumentResponse = instrument.sendCmd(string);
                    if (instrumentResponse.isError()) {
                        JOptionPane.showMessageDialog(Sniffer.window, "An error occurred while attempting to connect to the CEC log server.  The command was:\n" + string + "\nThe response was:\n" + instrumentResponse.getResponse());
                        return;
                    }
                    string = String.format("CEC%1d:BUSM:ON", this.capturePortCEC);
                    instrumentResponse = instrument.sendCmd(string);
                }
                this.capturing = true;
            }
        }
    }

    public int setCapturePortDDC(int n) {
        if (!this.capturing) {
            this.capturePortDDC = n;
        }
        return this.capturePortDDC;
    }

    public int setCapturePortCEC(int n) {
        if (!this.capturing) {
            this.capturePortCEC = n;
        }
        return this.capturePortCEC;
    }

    public int setCaptureDisplayPort(int n) {
        if (!this.capturing) {
            this.capturePortDisplayPort = n;
        }
        return this.capturePortDisplayPort;
    }

    public static void enable5VoltTPA(boolean bl) {
        String string;
        String string2;
        if (bl) {
            string2 = "QD:DCPX:LOGG 1";
            string = "enable";
        } else {
            string2 = "QD:DCPX:LOGG 0";
            string = "disable";
        }
        InstrumentResponse instrumentResponse = instrument.sendCmd(string2);
        if (instrumentResponse.isError()) {
            JOptionPane.showMessageDialog(Sniffer.window, "Unable to " + string + " the TPA:\n" + instrumentResponse.getResponse());
        }
    }

    public static void enableHPDDetection(boolean bl) {
        String string;
        String string2;
        if (bl) {
            string2 = "ADM" + MainAppFrame.analyzerDisplayPort + ":EHPD 1";
            string = "enable";
        } else {
            string2 = "ADM" + MainAppFrame.analyzerDisplayPort + ":EHPD 0";
            string = "disable";
        }
        InstrumentResponse instrumentResponse = instrument.sendCmd(string2);
        if (instrumentResponse.isError()) {
            JOptionPane.showMessageDialog(Sniffer.window, "Unable to " + string + " HPD Detection:\n" + instrumentResponse.getResponse());
        }
    }

    public static void enablePrechargeSyncDetection(boolean bl) {
        String string;
        String string2;
        if (bl) {
            string2 = "ADM" + MainAppFrame.analyzerDisplayPort + ":EPRE 1";
            string = "enable";
        } else {
            string2 = "ADM" + MainAppFrame.analyzerDisplayPort + ":EPRE 0";
            string = "disable";
        }
        InstrumentResponse instrumentResponse = instrument.sendCmd(string2);
        if (instrumentResponse.isError()) {
            JOptionPane.showMessageDialog(Sniffer.window, "Unable to " + string + " Precharge/Sync Detection:\n" + instrumentResponse.getResponse());
        }
    }

    public boolean isCapturing() {
        return this.capturing;
    }
}

